<?php
namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly	
}

/**
 *  Fact & Digit Widget.
*/
 
class Boldman_Imagebox_Widget extends Widget_Base{

	public function get_name() {
		return 'tm_imagebox_element';
	}

	public function get_title() {
		return esc_attr__( 'Image Box', 'boldman' );
	}

	public function get_icon() {
		return 'eicon-image';
	}

	public function get_categories() {
		return [ 'boldman_category' ];
	}

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
	}  
	
	protected function register_controls() {

		$this->start_controls_section(
			'data_section',
			[
				'label' => esc_attr__( 'Content', 'boldman' ),
			]
        );
		
		
		$this->add_control(
			'view',
			[
				'label'			=> esc_attr__( 'Design', 'boldman' ),
				'description'	=> esc_attr__( 'Select box design.', 'boldman' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'default'		=> 'one',
				'options' => [
					'one'	=> esc_attr( 'Style 1' ),
					'two'	=> esc_attr( 'Style 2' ),
					'three'	=> esc_attr( 'Style 3' ),
					'four'	=> esc_attr( 'Style 4' ),
				],
			]
		);
		$this->add_control(
			'image',
			[
				'label'			=> esc_attr__( 'Choose Image', 'boldman' ),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				]
			]
		);
		
		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'image',
				'default' => 'large',
				'separator' => 'none',
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => __( 'Alignment', 'boldman' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'boldman' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'boldman' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'boldman' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
            'tm_reveal_effects_enable',
            [
                'label'              => esc_html__('Use Reveal Effects?', 'boldman'),
                'type'               => Controls_Manager::SWITCHER,
                'render_type'        => 'none',
                'frontend_available' => true,
                'prefix_class'       => 'tm-reveal-effects-',
            ]
        );
        $this->add_control(
            'tm_reveal_effects_direction',
            [
                'label'              => __('Direction', 'bdthemes-element-pack'),
                'type'               => Controls_Manager::SELECT,
                'default'            => 'lr',
                'options'            => [
                    'lr' => __('Left to Right', 'boldman'),
                    'rl' => __('Right to Left', 'boldman'),
                   ],
                'frontend_available' => true,
				'prefix_class'       => 'tm-reveal-direction-',
                'condition'          => [
                    'tm_reveal_effects_enable' => 'yes'
                ]
            ]
        );
		
		$this->end_controls_section();

	}

	protected function render() {

		$settings	= $this->get_settings_for_display();
		extract($settings);
		
		global $tm_global_imagebox_element_values;
		$tm_global_imagebox_element_values = array();
		
		$return = '';


		$class         = array();

		if( !empty($view) ){
			$class[] = 'tm-imgbox-'.$view;
		}

		
		// Media image
			$image_html		= '' ;
			if( defined('ELEMENTOR_VERSION') ){
				$image_html = Group_Control_Image_Size::get_attachment_image_src( $settings['image']['id'], 'image', $settings );
				if( !empty($image_html) ){
					$image_html = '<img src="'.esc_url($image_html).'" class="tm-single-image-img" alt="Image"/>';
				}

			}
			
			
		if( file_exists( locate_template( '/template-parts/imagebox/imagebox.php', false, false ) ) ){

			ob_start();
			include( locate_template( '/template-parts/imagebox/imagebox.php', false, false ) );
			$return .= ob_get_contents();
			ob_end_clean();

		}
		
		echo themetechmount_wp_kses($return);

	}


}
// Register widget
Plugin::instance()->widgets_manager->register_widget_type( new Boldman_Imagebox_Widget() );