<?php

/**
 * Add group in Elementor editor
 */
if( !function_exists('tm_elements_manager') ){
function tm_elements_manager() {
	\Elementor\Plugin::$instance->elements_manager->add_category( 
		'boldman_category',
		[
			'title' => esc_attr__( 'Boldman Special Elements', 'boldman' ),
			'icon' => 'fa fa-plug',
		],
		1 // tab position
	);
}
}
add_action( 'elementor/init', 'tm_elements_manager' );

define( 'BOLDMAN_ICON_URL',  get_template_directory( __FILE__ )  ); 

/**
 * Adding custom theme icons
 */
 
if( !function_exists('tm_elementor_add_custom_icons_tab') ){
function tm_elementor_add_custom_icons_tab( $icons_tabs = array() ) {

	if( defined('BOLDMAN_ICON_URL') ){

		$tm_boldman_icons_array = array(
			'handyman-tools',
			'handy-man-worker-silhouette',
			'pipeline',
			'faucet',
			'tap',
			'pipe',
			'pipe-1',
			'pipe-2',
			'faucet-1',
			'electrician',
			'broken-cable',
			'electrician-1',
			'broken-cable-1',
			'broken-cable-2',
			'electrician-2',
			'welder',
			'welder-1',
			'welder-2',
			'welder-3',
			'welder-4',
			'welder-5',
			'welder-6',
			'window',
			'vacuum',
			'man-cleaning',
			'house',
			'lawn-mower',
			'plumber',
			'plumber-1',
			'carpenter',
			'carpenter-working',
			'saw',
			'carpenter-1',
			'worker-with-harness',
			'pliers',
			'electrician-3',
			'minisplit',
			'plumber-working',
			'paint-roller',
			'paint-palette-and-brush',
			'man-painting-wall',
			'man',
			'air-conditioner',
			'maintenance',
			'house-repair',
			'circular-saw',
			'trowel',
			'wall',
			'paint',
			'brick',
			'paint-roller-1',
			'pipe-3',
			'anvil',
			'hot-glue',
			'pipe-4',
			'level',
			'helmet',
			'worker-with-safety-helmet',
			'plumber-2',
			'fan',
			'paving',
			
		);
		
		$icons_tabs['kw_boldman'] = array(
			'name'          => 'kw_boldman',
			'label'         => esc_html__( 'Boldman Special Icons', 'boldman' ),
			'labelIcon'     => 'kw_boldman flaticon-workspace',
			'prefix'        => 'flaticon-',
			'displayPrefix' => 'kw_boldman',
			'url'           => wp_enqueue_style( 'themetechmount-boldman-extra-icons', get_template_directory_uri() . '/assets/themetechmount-boldman-extra-icons/font/flaticon.css' ),
			'icons'         => $tm_boldman_icons_array,
			'ver'           => '1.0.0',
		);
		
	}
	
	
	return $icons_tabs;
}
}
add_filter( 'elementor/icons_manager/additional_tabs', 'tm_elementor_add_custom_icons_tab' );


/**
 *  Add preview js for Elementor
 */
function tm_elementor_preview_scripts(){
	if ( defined('ELEMENTOR_VERSION') && \Elementor\Plugin::$instance->preview->is_preview_mode() ) {
		wp_enqueue_script(  'boldman-elementor-preview', get_template_directory_uri() . '/inc/elementor-preview.js' );
	}
}
add_action( 'wp_enqueue_scripts', 'tm_elementor_preview_scripts' );

function tm_elementor_enqueue_base_scripts(){
	wp_enqueue_script(  'boldman-functions', get_template_directory_uri() . '/js/functions.js' );
	wp_enqueue_script(  'boldman-elementor-main', get_template_directory_uri() . '/inc/elementor-main.js' );
}
add_action('elementor/editor/before_enqueue_scripts', 'tm_elementor_enqueue_base_scripts');


/**
 * Creating element widgets now*/
 
add_action( 'elementor/widgets/widgets_registered', 'tm_elementor_register_widgets',1,1 );
function tm_elementor_register_widgets() {

    if ( defined( 'ELEMENTOR_PATH' ) && class_exists('Elementor\Widget_Base') ) {

        require_once( get_template_directory() . '/inc/elementor/heading-subheading.php' );
		require_once( get_template_directory() . '/inc/elementor/icon-heading.php' );
		require_once( get_template_directory() . '/inc/elementor/fid.php' );
		require_once( get_template_directory() . '/inc/elementor/tm-testimonial.php' );
		require_once( get_template_directory() . '/inc/elementor/tm-blog.php' );
		require_once( get_template_directory() . '/inc/elementor/tm-team.php' );
		require_once( get_template_directory() . '/inc/elementor/tm-client.php' );
		require_once( get_template_directory() . '/inc/elementor/tm-portfolio.php' );
		require_once( get_template_directory() . '/inc/elementor/pricing-table.php' );
		require_once( get_template_directory() . '/inc/elementor/static-box.php' );
		require_once( get_template_directory() . '/inc/elementor/imagebox.php' );
		require_once( get_template_directory() . '/inc/elementor/tm-tabs.php' );
		require_once( get_template_directory() . '/inc/elementor/tm-service.php' );
		if( class_exists('Tribe__Events__Main') ){
			require_once( get_template_directory() . '/inc/elementor/tm-events.php' );
		}
		require_once( get_template_directory() . '/inc/elementor/static-box2.php' );
		require_once( get_template_directory() . '/inc/elementor/marque-box.php' );
    }
}

if( !function_exists('tm_link_render') ){
function tm_link_render( $value=array(), $type='start' ) {
	if( !empty($value) && is_array($value) && !empty($value['url']) ){
		if( $type=='start' ){
			$target		= $value['is_external'] ? ' target="_blank"' : '';
			$nofollow	= $value['nofollow'] ? ' rel="nofollow"' : '';
			return themetechmount_wp_kses( '<a href="' . $value['url'] . '"' . $target . $nofollow . '><span>' ); 
		} else {
			return themetechmount_wp_kses( '</span></a>' ); 
		}
	}
}
}

/***Themetechmount Iconbox Element code***/

if( !function_exists('themetechmount_iconbox_ele') ){
function themetechmount_iconbox_ele( $settings, $echo=false ){
	$return = '';
	
	if( !empty($settings['icon_type']) ){

		switch( $settings['icon_type'] ){

			case 'icon':
				if( !empty($ttm_data['icon']['value']) ){
					$return = '<i class="'.esc_attr( $settings['icon']['value'] ).'"></i>';

				}
				break;

			case 'image':
				if( !empty($settings['icon_image']['url']) ){
					$return = '<img src="'.esc_attr( $settings['icon_image']['url'] ).'" />';
				}
			break;

			case 'text':
				if( !empty($settings['icon_text']) ){
					$return = '<div class="tm-iheading-icontext">'.esc_attr($settings['icon_text']).'</div>';
				}
				break;

		}

	}
	if( !empty($return) ){
		$return = themetechmount_wp_kses('<div class="tm-iheading-icon tm-iheading-icon-type-'.esc_attr($settings['icon_type']).'">'.$return.'</div>');
	}

	if( $echo == true ){
		echo themetechmount_wp_kses($return);
	} else {
		return themetechmount_wp_kses($return);
	}

}
}

/**
 *  Heading Sub Heading Element.
 */

if( !function_exists('tm_heading_subheading') ){
function tm_heading_subheading( $settings = array(), $echo = false ){

	// Reverse heading class
	$reverse_class = '';
	if( !empty($settings['reverse_heading']) && $settings['reverse_heading']=='yes' ){
		$reverse_class = 'tm-reverse-heading-yes';
	}
	
	// desc heading class
	$desc = '';
	if( !empty($settings['desc'] )){
		$desc = 'tm-content-with-desc';
	}
	
	$heading_style = '';
	
	$return = '<div class="tm-element-heading-content-wrapper ' . themetechmount_wp_kses($settings['text_align']) . '-align '.esc_attr($reverse_class).' tm-seperator-'. themetechmount_wp_kses($settings['heading_sep']) .' '.esc_attr($desc).' tm-heading-style-'. themetechmount_wp_kses($settings['heading_style']) .' ">';
	
	$heading = '';
	
	// icon
	$return .= themetechmount_iconbox_ele($settings);
	
	$return .= themetechmount_wp_kses('<div class="tm-content-header">');
	
	// Heading
	if( !empty($settings['heading']) ) {
		$heading_tag = ( !empty($settings['heading_tag']) ) ? $settings['heading_tag'] : 'h2' ;

		$heading .= '<'. themetechmount_wp_kses($heading_tag) . ' class="tm-element-content-heading tm-custom-heading ">
				'.themetechmount_wp_kses($settings['heading']).'
			</'. themetechmount_wp_kses($heading_tag) . '>
		';
	}

	// reverse before heading
	if( empty($settings['reverse_heading']) && !empty($heading) ){
		$return .= themetechmount_wp_kses($heading);
	}

	// subheading
	if( !empty($settings['subheading']) ) {
		$subheading_tag	= ( !empty($settings['subheading_tag']) ) ? $settings['subheading_tag'] : 'h4' ;
		$subheading		= '<'. themetechmount_wp_kses($subheading_tag) . ' class="tm-element-subheading tm-custom-heading ">
				'.themetechmount_wp_kses($settings['subheading']).'
			</'. themetechmount_wp_kses($subheading_tag) . '>
		';
		$return .= themetechmount_wp_kses($subheading);
	}

	// Heading after sub-title
	if( !empty($settings['reverse_heading']) && !empty($heading) ){
		$return .= themetechmount_wp_kses($heading);
	}

	$return .= themetechmount_wp_kses('<div class="heading-seperator"><span></span></div></div>');
	if( !empty($settings['desc']) ){
		$desc = '<div class="tm-element-content-desctxt">'.themetechmount_wp_kses($settings['desc']).'</div>';
		$return .= themetechmount_wp_kses($desc);
	}
	// closing div
	$return .= themetechmount_wp_kses('</div>');

	// final output
	if( $echo == true ){
		echo themetechmount_wp_kses($return);
	} else {
		return themetechmount_wp_kses($return);
	}

}
}

add_action('elementor/element/section/section_layout/before_section_start', 'tm_elementor_section_options', 10);
if( !function_exists('tm_elementor_section_options') ){
function tm_elementor_section_options( $element ){

	$element->start_controls_section(
		'tm_element_section_title',
		[
			'label' => __('Boldman Special Options', 'boldman'),
			'tab' => Elementor\Controls_Manager::TAB_LAYOUT,
		]
	);
	
	$element->add_control(
		'tm_break_col',
		[
			'label'			=> esc_html__( 'Break Column in Ipad Screen', 'boldman' ),
			'description'	=> esc_html__( 'Pre-defined Break Column', 'boldman' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'default'		=> 'no',
			'prefix_class'	=> 'tm-column-break-ipad-',
			'options' => [
				'no' 			=> __( 'No', 'boldman' ),
				'yes'		=> __( 'Yes', 'boldman' ),
			],
		]
	);

	$element->add_control(
		'tm-extended-column',
		[
			'label'			=> esc_attr__( 'Exapand Column Background', 'boldman' ),
			'description'	=> esc_attr__( 'Exapand Column BG to left or right. This will expand the Background image/color visibility to border of the browser border.', 'boldman' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'label_block'	=> true,
			'hide_in_inner' => true,
			'default'		=> 'none',
			'prefix_class'	=> 'tm-col-stretched-',
			'options'		=> [
				'none' 			=> __( 'No expand (default)', 'boldman' ),
				'left'		=> __( 'Exapand Column background to left', 'boldman' ),
				'right'		=> __( 'Exapand Column background to right', 'boldman' ),	
				'both'		=> __( 'Exapand Column background to both', 'boldman' ),				
			],
		]
	);


	$element->add_control(
		'tm-strech-content-left',
		[
			'label'			=> esc_attr__( 'Also stretch left content too?', 'boldman' ),
			'description'	=> esc_attr__( 'Also stretch left content too?', 'boldman' ),
			'type'			=> Elementor\Controls_Manager::SWITCHER,
			'prefix_class'	=> 'tm-left-col-stretched-content-',
			'hide_in_inner' => true,
			'label_on'		=> esc_attr__( 'Yes', 'boldman' ),
			'label_off'		=> esc_attr__( 'No', 'boldman' ),
			'return_value'	=> 'yes',
			'default'		=> '',
			'condition'		=> [
				'tm-extended-column' => array('left', 'both'),
			]
		]
	);
	$element->add_control(
		'tm-strech-content-right',
		[
			'label'			=> esc_attr__( 'Also stretch right content too?', 'boldman' ),
			'description'	=> esc_attr__( 'Also stretch right content too?', 'boldman' ),
			'type'			=> Elementor\Controls_Manager::SWITCHER,
			'prefix_class'	=> 'tm-right-col-stretched-content-',
			'hide_in_inner' => true,
			'label_on'		=> esc_attr__( 'Yes', 'boldman' ),
			'label_off'		=> esc_attr__( 'No', 'boldman' ),
			'return_value'	=> 'yes',
			'default'		=> '',
			'condition'		=> [
				'tm-extended-column' => array('right', 'both'),
			]
		]
	);
	
	
	$element->add_control(
		'tm-left-margin',
		[
			'label'			=> esc_html__( 'Left Content Area Margin', 'boldman' ),
			'description'	=> esc_html__( 'This is useful if you like to overlap columns on each other.', 'boldman' ),
			'type'			=> Elementor\Controls_Manager::DIMENSIONS,
			'separator'		=> 'before',
			'selectors' => [
				'{{WRAPPER}} .tm-stretched-div.tm-stretched-left' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);

	$element->add_control(
		'tm-right-margin',
		[
			'label'			=> esc_html__( 'Right Content Area Margin', 'boldman' ),
			'description'	=> esc_html__( 'This is useful if you like to overlap columns on each other.', 'boldman' ),
			'type'			=> Elementor\Controls_Manager::DIMENSIONS,
			'selectors' => [
				'{{WRAPPER}} .tm-stretched-div.tm-stretched-right' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);

	$element->add_control(
		'tm_bg_color',
		[
			'label'			=> esc_html__( 'Background Color', 'boldman' ),
			'description'	=> esc_html__( 'Select Background Color. If you select color and also select background Video or background Image than the color will be overlay with some opacity', 'boldman' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'default'		=> '',
			'separator'		=> 'before',
			'prefix_class'	=> 'tm-bgcolor-',
			"weight"      => 1,
			'options'		=> [
				'' 		=> esc_attr__( 'Transparent (From Design Options tab)', 'boldman' ),
				'darkgrey'		=> esc_attr__( 'Dark grey color as background color', 'boldman' ),
				'grey'			=> esc_attr__( 'Grey color as background color', 'boldman' ),
				'white'	        => esc_attr__( 'White color as background color', 'boldman' ),
				'skincolor'  	=> esc_attr__( 'Skincolor color as background color', 'boldman' ),				
			],
		]
	);

	$element->add_control(
		'tm_text_color',
		[
			'label'			=> esc_html__( 'Section Text Color', 'boldman' ),
			'description'	=> esc_html__( 'Pre-defined Text Color in this Section (ROW)', 'boldman' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'default'		=> '',
			'prefix_class'	=> 'tm-textcolor-',
			'options' => [
				'' 			=> __( 'Default', 'boldman' ),
				'white'		=> __( 'White Color', 'boldman' ),
				'dark'		=> __( 'Dark Color', 'boldman' ),
				'skincolor'	=> __( 'Skin Color', 'boldman' ),
			],
		]
	);

		$element->add_control(
		'tm_section_hightl_bg',
		[
			'label' => esc_attr__( 'HighLight BG Color One', 'capiza' ),
			'description' => esc_attr__( 'show highLight background dot color one.', 'capiza' ),
			'type' => Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_attr__( 'Yes', 'capiza' ),
			'label_off' => esc_attr__( 'No', 'capiza' ),
			'prefix_class'	=> 'prt-highlight-bg-',
			'return_value' => 'yes',
			'default' => '',
		]
	);
	
	$element->add_control(
		'tm_section_hightl_bg1_color',
		[
			'label' => esc_attr__( 'High Light BG Color One', 'capiza' ),
			'description' => esc_attr__( 'show highLight background color.', 'capiza' ),
			'type' => Elementor\Controls_Manager::COLOR,
			'default' => '',
				'selectors' => [
					'{{WRAPPER}} .prt-section-hili-dot.prt-hilidot-left' => 'color: {{VALUE}};',
				],
			'condition'		=> [
				'tm_section_hightl_bg' => 'yes',
			]
		]
	);

	
		$start = is_rtl() ? esc_html__( 'Right', 'elementor' ) : esc_html__( 'Left', 'elementor' );
		$end = ! is_rtl() ? esc_html__( 'Right', 'elementor' ) : esc_html__( 'Left', 'elementor' );

		$element->add_control(
			'tmhis_offset_orientation_h',
			[
				'label' => esc_html__( 'Horizontal Orientation', 'elementor' ),
				'type' => Elementor\Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => $start,
						'icon' => 'eicon-h-align-left',
					],
					'end' => [
						'title' => $end,
						'icon' => 'eicon-h-align-right',
					],
				],
				'classes' => 'elementor-control-start-end',
				'render_type' => 'ui',
				'condition'		=> [
					'tm_section_hightl_bg' => 'yes',
				]
			]
		);
		
		$element->add_responsive_control(
			'tmhis_offset_x',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'size' => '0',
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'body:not(.rtl) {{WRAPPER}} .prt-hilidot-left' => 'left: {{SIZE}}{{UNIT}}',
					'body.rtl {{WRAPPER}} .prt-hilidot-left' => 'right: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_h!' => 'end',
					'tm_section_hightl_bg' => 'yes',
				],
			]
		);
		
		$element->add_responsive_control(
			'tmhis_offset_x_end',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 0.1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'size' => '0',
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'body:not(.rtl) {{WRAPPER}} .prt-hilidot-left' => 'right: {{SIZE}}{{UNIT}}',
					'body.rtl {{WRAPPER}} .prt-hilidot-left' => 'left: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_h' => 'end',
					'tm_section_hightl_bg' => 'yes',
				],
			]
		);
		
		$element->add_control(
			'tmhis_offset_orientation_v',
			[
				'label' => esc_html__( 'Vertical Orientation', 'elementor' ),
				'type' => Elementor\Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => esc_html__( 'Top', 'elementor' ),
						'icon' => 'eicon-v-align-top',
					],
					'end' => [
						'title' => esc_html__( 'Bottom', 'elementor' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'render_type' => 'ui',
				'condition'		=> [
					'tm_section_hightl_bg' => 'yes',
				],
			]
		);
		
		$element->add_responsive_control(
			'tmhis_offset_y',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'default' => [
					'size' => '0',
				],
				'selectors' => [
					'{{WRAPPER}} .prt-hilidot-left' => 'top: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_v!' => 'end',
					'tm_section_hightl_bg' => 'yes',
				],
			]
		);

		$element->add_responsive_control(
			'tmhis_offset_y_end',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'default' => [
					'size' => '0',
				],
				'selectors' => [
					'{{WRAPPER}} .prt-hilidot-left' => 'bottom: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_v' => 'end',
					'tm_section_hightl_bg' => 'yes',
				],
			]
		);

		$element->add_responsive_control(
			'tmhis_z_index',
			[
				'label' => esc_html__( 'Z-Index', 'elementor' ),
				'type' => Elementor\Controls_Manager::NUMBER,
				'selectors' => [
					'{{WRAPPER}} .prt-hilidot-left' => 'z-index: {{VALUE}};',
				],
				'condition'		=> [
					'tm_section_hightl_bg' => 'yes',
				],
			]
		);
		$element->add_control(
			'tmhis_font_size',
			[
				'label' => esc_html__( 'Font Size', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'default' => [
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .prt-hilidot-left' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition'		=> [
					'tm_section_hightl_bg' => 'yes',
				],
			]
		);
		
		$element->add_control(
		'tm_section_hight2_bg',
		[
			'label' => esc_attr__( 'HighLight BG Color Two', 'capiza' ),
			'description' => esc_attr__( 'show high light background dot color two.', 'capiza' ),
			'type' => Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_attr__( 'Yes', 'capiza' ),
			'label_off' => esc_attr__( 'No', 'capiza' ),
			'prefix_class'	=> 'prt-highlight-bg-',
			'return_value' => 'yes',
			'default' => '',
		]
	);
	
	$element->add_control(
		'tm_section_hightl_bg2_color',
		[
			'label' => esc_attr__( 'High Light BG Color Two', 'capiza' ),
			'description' => esc_attr__( 'show high light background color.', 'capiza' ),
			'type' => Elementor\Controls_Manager::COLOR,
			'default' => '',
				'selectors' => [
					'{{WRAPPER}} .prt-section-hili-dot.prt-hilidot-right' => 'color: {{VALUE}};',
				],
			'condition'		=> [
				'tm_section_hight2_bg' => 'yes',
			]
		]
	);
	
	$element->add_control(
			'tmhis_offset_orientation_h2',
			[
				'label' => esc_html__( 'Horizontal Orientation', 'elementor' ),
				'type' => Elementor\Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => $start,
						'icon' => 'eicon-h-align-left',
					],
					'end' => [
						'title' => $end,
						'icon' => 'eicon-h-align-right',
					],
				],
				'classes' => 'elementor-control-start-end',
				'render_type' => 'ui',
				'condition'		=> [
					'tm_section_hight2_bg' => 'yes',
				]
			]
		);
		
		$element->add_responsive_control(
			'tmhis_offset_x2',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'size' => '0',
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'body:not(.rtl) {{WRAPPER}} .prt-hilidot-right' => 'left: {{SIZE}}{{UNIT}}',
					'body.rtl {{WRAPPER}} .prt-hilidot-right' => 'right: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_h2!' => 'end',
					'tm_section_hight2_bg' => 'yes',
				],
			]
		);
		
		$element->add_responsive_control(
			'tmhis_offset_x2_end',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 0.1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'size' => '0',
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'body:not(.rtl) {{WRAPPER}} .prt-hilidot-right' => 'right: {{SIZE}}{{UNIT}}',
					'body.rtl {{WRAPPER}} .prt-hilidot-right' => 'left: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_h2' => 'end',
					'tm_section_hight2_bg' => 'yes',
				],
			]
		);
		
		$element->add_control(
			'tmhis_offset_orientation_v2',
			[
				'label' => esc_html__( 'Vertical Orientation', 'elementor' ),
				'type' => Elementor\Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => esc_html__( 'Top', 'elementor' ),
						'icon' => 'eicon-v-align-top',
					],
					'end' => [
						'title' => esc_html__( 'Bottom', 'elementor' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'render_type' => 'ui',
				'condition'		=> [
					'tm_section_hight2_bg' => 'yes',
				],
			]
		);
		
		$element->add_responsive_control(
			'tmhis_offset_y2',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'default' => [
					'size' => '0',
				],
				'selectors' => [
					'{{WRAPPER}} .prt-hilidot-right' => 'top: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_v2!' => 'end',
					'tm_section_hight2_bg' => 'yes',
				],
			]
		);

		$element->add_responsive_control(
			'tmhis_offset_y2_end',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'default' => [
					'size' => '0',
				],
				'selectors' => [
					'{{WRAPPER}} .prt-hilidot-right' => 'bottom: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_v2' => 'end',
					'tm_section_hight2_bg' => 'yes',
				],
			]
		);

		$element->add_responsive_control(
			'tmhis_z_index2',
			[
				'label' => esc_html__( 'Z-Index', 'elementor' ),
				'type' => Elementor\Controls_Manager::NUMBER,
				'selectors' => [
					'{{WRAPPER}} .prt-hilidot-right' => 'z-index: {{VALUE}};',
				],
				'condition'		=> [
					'tm_section_hight2_bg' => 'yes',
				],
			]
		);
		$element->add_control(
			'tmhis_font_size2',
			[
				'label' => esc_html__( 'Font Size', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'default' => [
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .prt-hilidot-right' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition'		=> [
					'tm_section_hight2_bg' => 'yes',
				],
			]
		);
		

	$element->end_controls_section();
}
}


/**
 * Elementor column options
 */
add_action('elementor/element/column/layout/before_section_start', 'tm_elementor_column_options', 10);
if( !function_exists('tm_elementor_column_options') ){
function tm_elementor_column_options( $element ){

	$element->start_controls_section(
		'tm_element_section_title',
		[
			'label' => __('Boldman Special Options', 'boldman'),
			'tab' => Elementor\Controls_Manager::TAB_LAYOUT,
		]
	);

	$element->add_control(
		'tm_bg_color',
		[
			'label'			=> esc_html__( 'Column Background Color', 'boldman' ),
			'description'	=> esc_html__( 'Pre-defined Background Color for this Column', 'boldman' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'default'		=> '',
			'prefix_class'	=> 'tm-bgcolor-yes tm-col-bgcolor-',
			"weight"      => 1,
			'options'		=> [
				'' 			=> esc_attr__( 'Transparent (From Design Options tab)', 'boldman' ),
				'darkgrey'		=> esc_attr__( 'Dark grey color as background color', 'boldman' ),
				'grey'			=> esc_attr__( 'Grey color as background color', 'boldman' ),
				'white'	        => esc_attr__( 'White color as background color', 'boldman' ),
				'skincolor'  	=> esc_attr__( 'Skincolor color as background color', 'boldman' ),				
			],
		]
	);

	$element->add_control(
		'tm_text_color',
		[
			'label'			=> esc_html__( 'Column Text Color', 'boldman' ),
			'description'	=> esc_html__( 'Pre-defined Text Color in this Column', 'boldman' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'default'		=> '',
			'prefix_class'	=> 'tm-textcolor-',
			'options' => [
				'' 			=> __( 'Default', 'boldman' ),
				'white'		=> __( 'White Color', 'boldman' ),
				'dark'		=> __( 'Dark Color', 'boldman' ),
				'skincolor'	=> __( 'Skin Color', 'boldman' ),
			],
		]
	);

	$element->end_controls_section();
}
}



/**
 * Elementor button options
 */
add_action('elementor/element/button/section_button/before_section_start', 'tm_elementor_button_options', 10);
if( !function_exists('tm_elementor_button_options') ){
function tm_elementor_button_options( $element ){

	$element->start_controls_section(
		'tm_element_section_title',
		[
			'label' => __('Boldman Special Options', 'boldman'),
			'tab' => Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
		
	$element->add_control(
		'color',
		[
			'label'			=> esc_html__( 'Button Color', 'boldman' ),
			'description'	=> esc_html__( 'Pre-defined Color for Button', 'boldman' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'default'		=> 'skincolor',
			'label_block'	=> true,
			'prefix_class'	=> 'tm-btn-color-',
			'options' => [
				'darkgrey'		=> esc_attr__( 'Dark Grey', 'boldman' ),
				'grey'			=> esc_attr__( 'Grey Color', 'boldman' ),
				'white'	        => esc_attr__( 'White Color', 'boldman' ),
				'skincolor'  	=> esc_attr__( 'Skin Color', 'boldman' ),
			],
		]
	);
	$element->add_control(
		'style',
		[
			'label'			=> esc_html__( 'Select Button Style', 'boldman' ),
			'description'	=> esc_html__( 'Button style', 'boldman' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'default'		=> 'flat',
			'label_block'	=> true,
			'prefix_class'	=> 'tm-btn-style-',
			'options' => [
				'flat' 			=> esc_attr__( 'Flat', 'boldman' ),
				'outline'		=> esc_attr__( 'Outline', 'boldman' ),
				'text'			=> esc_attr__( 'Simple text', 'boldman' ),
			],
		]
	);
	
	$element->add_control(
		'shape',
		[
			'label'			=> esc_attr__( 'Select button shape.', 'boldman' ),
			'description'	=> esc_attr__( 'Select button shape.', 'boldman' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'label_block'	=> true,
			'prefix_class'	=> 'tm-btn-shape-',
			'default'		=> 'square',
			'options' => [
				'square' 		=> esc_attr__( 'Square', 'boldman' ),
				'rounded'		=> esc_attr__( 'Rounded', 'boldman' ),
				'round'			=> esc_attr__( 'Round', 'boldman' ),
			],
		]

	);
	
	$element->add_control(
			'icon-pos',
			[
				'label' => __( 'Icon Position', 'boldman' ),
				'type' => Elementor\Controls_Manager::SELECT,
				'label_block'	=> true,
				'prefix_class'	=> 'tm-icon-align-',
				'default' => 'left',
				'options' => [
					'left'  => __( 'Before', 'boldman' ),
					'right' => __( 'After', 'boldman' ),
				],
				'condition' => [
					'selected_icon[value]!' => '',
				],
			]
		);
		
		
	$element->end_controls_section();
}
}
	
/* enable builder for custom cpt */

if( !function_exists('tm_elementor_enable_cpt_support') ){
function tm_elementor_enable_cpt_support() {

	$cpt_support  = array( 'page', 'post', 'tm_portfolio', 'tm_service', 'tm_team_member' );
	update_option( 'elementor_cpt_support', $cpt_support  );

}
}
add_action( 'after_switch_theme', 'tm_elementor_enable_cpt_support' );

if( !function_exists('tm_elementor_add_extra_icons_tab') ){
function tm_elementor_add_extra_icons_tab( $icons_newtabs = array() ) {
	
	$advance_icon_library  = themetechmount_get_option('advance_icon_library');
	
	if( defined('BOLDMAN_ICON_URL') && ( $advance_icon_library == true ) ){

		$tm_boldman_extra_icons_array = array(
			'sanitizer',
			'insecticide',
			'insecticide-1',
			'pest-control-1',
			'bug-spray',
			'pesticide-2',
			'cockroach',
			'pest-control',
			'plumber',
			'plumber-2',
			'plumber-4',
			'basin',
			'water-pipe',
			'electrician',
			'multimeter',
			'home-repair',
			'multimeter-1',
			'electrician-2',
			'plugin',
			'plug',
			'ecosystem',
			'solar-cell',
			'solar-panel',
			'solar-energy',
			'solar-energy-1',
			'solar',
			'solar-energy-3',
			'solar-panel-1',
			'call',
			'envelope',
			'costumer',
			'quality',
			'right-arrow',
		);
		
		$icons_newtabs['kw_boldman_new'] = array(
			'name'          => 'kw_boldman_new',
			'label'         => esc_html__( 'Boldman Extra Icons', 'boldman' ),
			'labelIcon'     => 'kw_boldman tm-themeicons-workspace',
			'prefix'        => 'tm-themeicons-',
			'displayPrefix' => 'kw_boldman',
			'url'           => wp_enqueue_style( 'tm-boldman-custom-icons', get_template_directory_uri() . '/assets/tm-boldman-custom-icons/font/tm-themeicons.css' ),
			'icons'         => $tm_boldman_extra_icons_array,
			'ver'           => '1.0.0',
		);
		
	}
	
	return $icons_newtabs;
	
}
}
add_filter( 'elementor/icons_manager/additional_tabs', 'tm_elementor_add_extra_icons_tab' );